using System;
using System.Diagnostics;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using System.Data.SqlClient;

namespace ForeignKeyConstraint_Example {
    /// <summary>
    /// Summary description for Form1.
    /// </summary>
    public class Form1 : System.Windows.Forms.Form {
        /// <summary>
        /// Required designer variable.
        /// </summary>
        private System.ComponentModel.Container components = null;

        public Form1() {
            try {

                //
                // Required for Windows Form Designer support
                //
                InitializeComponent();

                //
                // TODO: Add any constructor code after InitializeComponent call
                //

                SqlConnection cn = new SqlConnection("database=biblio;Data Source=.;integrated security=sspi");
                SqlCommand scStates = new SqlCommand("SELECT StateCode, State FROM ValidStates ", cn);
                SqlCommand scAddr = new SqlCommand("SELECT AddrID, CustID, StateCode, City FROM Addresses WHERE StateCode IN (SELECT StateCode FROM ValidStates)", cn);
                SqlDataAdapter da = new SqlDataAdapter(scStates);
                DataTable dt = new DataTable();
                DataSet ds = new DataSet("CustomerAddress");
 
                da.Fill(ds, "States");
                da.SelectCommand = scAddr;
                da.Fill(ds, 1, 50, "Addresses");     // Get the first 50 rows.

                DataColumn parentCols;
                DataColumn childCols;
                ForeignKeyConstraint FKC; 
                
                // Set parent and child column variables.
                childCols = ds.Tables["Addresses"].Columns["StateCode"];
                parentCols = ds.Tables["States"].Columns["StateCode"];
                FKC = new ForeignKeyConstraint(parentCols, childCols);
                // Set constraint Rule properties.

                FKC.DeleteRule = Rule.SetDefault;
                FKC.UpdateRule = Rule.Cascade;
                FKC.AcceptRejectRule = AcceptRejectRule.Cascade;
            
                // Add the constraint, and set EnforceConstraints to true.
                ds.Tables["Addresses"].Constraints.Add(FKC);
                ds.EnforceConstraints = true;
            }
            catch( Exception ex) {
                Debug.WriteLine(ex.ToString());
                MessageBox.Show(ex.ToString());
            }

        }

        /// <summary>
        /// Clean up any resources being used.
        /// </summary>
        protected override void Dispose( bool disposing ) {
            if( disposing ) {
                if (components != null) {
                    components.Dispose();
                }
            }
            base.Dispose( disposing );
        }

		#region Windows Form Designer generated code
        /// <summary>
        /// Required method for Designer support - do not modify
        /// the contents of this method with the code editor.
        /// </summary>
        private void InitializeComponent() {
            // 
            // Form1
            // 
            this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
            this.ClientSize = new System.Drawing.Size(292, 273);
            this.Name = "Form1";
            this.Text = "Form1";


        }
		#endregion

        /// <summary>
        /// The main entry point for the application.
        /// </summary>
        [STAThread]
        static void Main() {
            Application.Run(new Form1());
        }


    }
}
